local function createArtifactsPower(self)
    local artifacts = self.detector.Artifacts
    for id, artifact in ipairs(artifacts) do
        if self.Image == artifact.Image then
			local artifactFlag = bit.lshift(1, id-1)
            self.detector.ArtifactsOwned = OR(self.detector.ArtifactsOwned, artifactFlag)
            CreateObject{name = "ArtifactPower:" .. artifact.Logic}
        end
    end
end

function main(self)

    self:AnimationStep()
    local claw = GetClaw()

    if self.State == 0 then
		self:SetAnimation("GAME_CYCLE100")
		self.AttackRect = {-18,-18,18,18}
		self.AttackFlags.Player = true
		self:CreateGlitter"GAME_WARPGLITTER"
        self.detector = GetObject(3206)
		self.State = 5
	end

	if self.State == 6 then
		self.X = self.X + 13
		self.Y = self.Y - 10
		if self.X > claw.X + 800 or self.Y < claw.Y - 450 then
			self:Destroy()
		end
	end

end

function attack(self)
	PlaySound("CUSTOM_ARTIFACT")
	self.AttackFlags.Player = false
	createArtifactsPower(self)
	self.State = 6
	self:DestroyGlitter()
end

